/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineCenterToMiddle.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CApplication.h"
#include "CLine.h"

//	Creates a line using the center point of the given circle and
//	the mid point of the given line and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineCenterToMiddle(ILine *circle1, ILine *line1, ILine **newLine1)
{

	START_METHOD("CreateLineCenterToMiddle")

	HRESULT status = CONV_SUCCESS;
	
	// Get the center point of the circle
	IPoint *centerPoint1 = NULL;
	status = circle1->GetCenterPoint(&centerPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the mid point of the line
	IPoint *midPoint1 = NULL;
	status = GetMidPoint(line1, &midPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(centerPoint1, midPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineCenterToMiddle")
}
